import * as React from 'react';

import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import { ButtonColor } from 'shared/consts/ButtonColor';
import { ButtonSize } from 'shared/consts/ButtonSize';
import { ButtonFile, ButtonFileProps } from 'shared/ui/ButtonFile/ButtonFile';

import AttachIcon from 'shared/ui/Icons/images/attach-16.inline.svg';

const storybookMeta = createStorybookMeta<ButtonFileProps>({
    title: 'shared/ButtonFile',
    component: ButtonFile,
});

export default storybookMeta;

const Template = createStorybookTemplate<
    ButtonFileProps,
    React.ForwardRefExoticComponent<React.PropsWithoutRef<ButtonFileProps> & React.RefAttributes<any>>
>(ButtonFile);

export const normal = Template.bind({});
normal.args = {
    size: ButtonSize.M,
    color: ButtonColor.SECONDARY,
    label: 'Choose file',
    icon: AttachIcon,
};
