import * as React from 'react';

import { Button, ButtonProps } from 'shared/ui/Button/Button';

import styles from 'shared/ui/ButtonFile/ButtonFile.css';

export interface ButtonFileProps extends ButtonProps {
    accept?: string;
    multiple?: boolean;

    onInputChange?(values: File[]): void;

    inputRef?: React.MutableRefObject<Nullable<HTMLInputElement>>;
}

export const ButtonFile = React.forwardRef<HTMLElement, ButtonFileProps>(function ButtonFile(
    { accept, multiple, onInputChange, inputRef, ...otherProps },
    ref,
) {
    const onClickHandler = React.useCallback(({ currentTarget }: React.MouseEvent<HTMLInputElement>) => {
        currentTarget.value = '';
    }, []);

    const onInputChangeHandler = React.useCallback(
        ({ currentTarget }: React.ChangeEvent<HTMLInputElement>) => {
            if (onInputChange) {
                onInputChange(currentTarget.files?.length ? Array.from(currentTarget.files) : []);
            }
        },
        [onInputChange],
    );

    return (
        <Button
            {...otherProps}
            tagName="label"
            ref={ref}
        >
            <input
                className={styles.input}
                type="file"
                accept={accept}
                multiple={multiple}
                onClick={onClickHandler}
                onChange={onInputChangeHandler}
                ref={inputRef}
            />
        </Button>
    );
});
