import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { hoverState } from 'tests/storybook/helpers/hoverState';

import { CalendarDay, CalendarDayProps } from 'shared/ui/CalendarDay/CalendarDay';

const DATE = new Date('2022-01-12');

const storybookMeta = createStorybookMeta<CalendarDayProps>({
    title: 'shared/CalendarDay',
    component: CalendarDay,

    parameters: { backgrounds: { default: 'white' } },

    args: {
        date: DATE,
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<CalendarDayProps>(CalendarDay);

export const normal = Template.bind({});
normal.hermioneFn = hoverState;

export const current = Template.bind({});
current.parameters = { date: DATE };
current.hermioneFn = hoverState;

export const selected = Template.bind({});
selected.args = { dayContext: { isDateSelected: () => true } };
selected.hermioneFn = hoverState;

export const selectedCorner = Template.bind({});
selectedCorner.args = { dayContext: { isFirstOrLastSelectedDate: () => true } };
selectedCorner.hermioneFn = hoverState;

export const disabled = Template.bind({});
disabled.args = { dayContext: { isDateBlocked: () => true } };
disabled.hermioneFn = hoverState;
