import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import { CalendarMonth, CalendarMonthProps } from 'shared/ui/CalendarMonth/CalendarMonth';

const DATE = new Date('2022-01-12');

const storybookMeta = createStorybookMeta<CalendarMonthProps>({
    title: 'shared/CalendarMonth',
    component: CalendarMonth,

    parameters: { backgrounds: { default: 'white' } },

    args: {
        month: DATE.getMonth(),
        year: DATE.getFullYear(),
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<CalendarMonthProps>(CalendarMonth);

export const normal = Template.bind({});

export const previousArrow = Template.bind({});
previousArrow.args = { arrows: 'previous' };

export const nextArrow = Template.bind({});
nextArrow.args = { arrows: 'next' };
