import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Choose year': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Choose year',
        ru: 'Выберите год',
        cs: 'Vyberte rok',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
