import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import { CalendarYear, CalendarYearProps } from 'shared/ui/CalendarYear/CalendarYear';

const storybookMeta = createStorybookMeta<CalendarYearProps>({
    title: 'shared/CalendarYear',
    component: CalendarYear,

    parameters: {
        backgrounds: { default: 'white' },
        date: new Date('2022-01-01'),
    },

    args: {
        storybookClassName: 'sb-calendar-year',
        storybookWidth: '284px',
        storybookHeight: '292px',
    },
});

export default storybookMeta;

async function hoverScrollState(browser: WebdriverIO.Browser, selector: string) {
    await browser.$('li[role="option"]:nth-child(3)').moveTo({ xOffset: 10, yOffset: 10 });
    await browser.assertView('hover-item', selector);

    await browser.$('body').moveTo({ xOffset: 1, yOffset: 1 });
    await browser.execute(function () {
        const element = document.querySelector('.sb-calendar-year');

        if (element) {
            // eslint-disable-next-line @typescript-eslint/no-magic-numbers
            element.firstElementChild?.scrollTo(0, 10000);
        }
    });

    return browser.assertView('withScroll', selector);
}

const Template = createStorybookTemplate<CalendarYearProps>(CalendarYear);

export const empty = Template.bind({});
empty.hermioneSelector = 'html';

export const withBackStep = Template.bind({});
withBackStep.args = { backYearStep: 100, checkedYear: 2022 };
withBackStep.hermioneFn = hoverScrollState;

export const withNextStep = Template.bind({});
withNextStep.args = { nextYearStep: 10, checkedYear: 2022 };
withNextStep.hermioneFn = hoverScrollState;

export const withSteps = Template.bind({});
withSteps.args = { backYearStep: 100, nextYearStep: 10, checkedYear: 2030 };
withSteps.hermioneFn = hoverScrollState;
