import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import { ChartLegendPopup, ChartLegendPopupProps } from 'shared/ui/ChartLegendPopup/ChartLegendPopup';

const storybookMeta = createStorybookMeta<ChartLegendPopupProps>({
    title: 'shared/ChartLegendPopup',
    component: ChartLegendPopup,

    args: {
        points: {
            begin_date: 1635109200000,
            end_date: 1635195600000,
            line1: 57,
            line2: 7.1,
            line3: 141,
            // eslint-disable-next-line @typescript-eslint/no-magic-numbers
            line4: [57, 7.1],
        },
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<ChartLegendPopupProps>(ChartLegendPopup);

export const empty = Template.bind({});
empty.args = { points: null };
empty.hermioneSelector = 'body';

export const one = Template.bind({});
one.args = { keys: ['line1'], legend: ['Mileage'] };

export const two = Template.bind({});
two.args = {
    keys: ['line1', 'line2'],
    keysFormat: [{ postfix: 'km' }, { prefix: '$' }],
    legend: ['Mileage', 'Revenue'],
};

export const three = Template.bind({});
three.args = {
    keys: ['line1', 'line2', 'line3'],
    keysFormat: [{}, { prefix: '$' }, { postfix: '%' }],
    legend: ['Hours', 'Revenue', 'Utilisation'],
};

export const oneKeyTwoLines = Template.bind({});
oneKeyTwoLines.args = {
    keys: ['line4'],
    keysFormat: [{}, { prefix: '$' }],
    legend: ['Hours', 'Revenue'],
};

export const twoDays = Template.bind({});
twoDays.args = {
    points: [
        {
            begin_date: 1635109200000,
            end_date: 1635195600000,
            line1: 57,
        },
        {
            begin_date: 1635195600000,
            end_date: 1635282000000,
            line1: 7.1,
        },
    ],
    keys: ['line1'],
    keysFormat: [{ postfix: ' km' }],
};

export const arrowLeft = Template.bind({});
arrowLeft.args = { keys: ['line1'], legend: ['Mileage'], arrowPosition: 'left' };

export const arrowRight = Template.bind({});
arrowRight.args = { keys: ['line1'], legend: ['Mileage'], arrowPosition: 'right' };
