import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'There is no data': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'There is no data',
        ru: 'Нет данных',
        cs: 'Nejsou k dispozici žádná data',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
