import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import { DateAggregation } from 'shared/consts/DateAggregation';
import TestChartPoint from 'shared/ui/ChartViewHistogram/__fixtures__/TestChartPoints.json';
import TestChartPointMonths from 'shared/ui/ChartViewHistogram/__fixtures__/TestChartPointsMonths.json';
import TestChartPointWeeks from 'shared/ui/ChartViewHistogram/__fixtures__/TestChartPointsWeeks.json';
import { ChartViewHistogram, ChartViewHistogramProps } from 'shared/ui/ChartViewHistogram/ChartViewHistogram';

import styles from 'shared/ui/ChartViewHistogram/ChartViewHistogram.story.css';

const storybookMeta = createStorybookMeta<ChartViewHistogramProps>({
    title: 'shared/ChartViewHistogram',
    component: ChartViewHistogram,

    parameters: { backgrounds: { default: 'grey' } },

    args: {
        storybookWidth: '600px',
        storybookHeight: '300px',
        storybookStyles: { backgroundColor: '#fff' },

        points: TestChartPoint,
        keys: ['line3'],
    },
});

export default storybookMeta;

const legend = async (browser: WebdriverIO.Browser, selector: string) => {
    await browser.$('[data-testid="ChartViewHistogram.bars"]').moveTo({ xOffset: 10, yOffset: 10 });

    return await browser.assertView('hovered', selector);
};

const Template = createStorybookTemplate<ChartViewHistogramProps>(ChartViewHistogram);

export const percents = Template.bind({});
percents.args = {
    aggregationConfig: {
        aggregation: DateAggregation.DAY,
    },
    keysFormat: [
        {
            fraction: 1,
            postfix: '%',
        },
    ],
    keys: ['line1'],
    className: styles.chartRed,
};
export const percentsOver = Template.bind({});
percentsOver.args = {
    aggregationConfig: {
        aggregation: DateAggregation.DAY,
    },
    keysFormat: [
        {
            fraction: 1,
            postfix: '%',
        },
    ],
    className: styles.chartRed,
};
export const sizeM = Template.bind({});
sizeM.args = {
    aggregationConfig: {
        aggregation: DateAggregation.DAY,
    },
    className: styles.chartRed,
};
sizeM.hermioneFn = legend;
export const weeks = Template.bind({});
weeks.args = {
    points: TestChartPointWeeks,
    className: styles.chartRed,
    aggregationConfig: {
        aggregation: DateAggregation.WEEK,
    },
    keys: ['line1'],
};
export const months = Template.bind({});
months.args = {
    points: TestChartPointMonths,
    className: styles.chartRed,
    aggregationConfig: {
        aggregation: DateAggregation.MONTH,
    },
    keys: ['line1'],
};

export const skippedStart = Template.bind({});
skippedStart.args = {
    aggregationConfig: {
        since: 1633294800,
        aggregation: DateAggregation.DAY,
    },
    className: styles.chartRed,
    points: TestChartPoint,
};

export const skippedEnd = Template.bind({});
skippedEnd.args = {
    aggregationConfig: {
        until: 1635986800,
        aggregation: DateAggregation.DAY,
    },
    className: styles.chartRed,
    points: TestChartPoint,
};

export const skippedRange = Template.bind({});
skippedRange.args = {
    aggregationConfig: {
        since: 1633294800,
        until: 1635886800,
        aggregation: DateAggregation.DAY,
    },
    className: styles.chartRed,
    points: TestChartPoint,
};
