import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { hoverState } from 'tests/storybook/helpers/hoverState';

import { Checkbox, CheckboxProps } from 'shared/ui/Checkbox/Checkbox';

const storybookMeta = createStorybookMeta<CheckboxProps>({
    title: 'shared/Checkbox',
    component: Checkbox,

    parameters: { backgrounds: { default: 'white' } },

    args: {
        storybookStyles: { lineHeight: 0 },

        label: 'Copy properties',
        id: 'copy-properties',
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<CheckboxProps>(Checkbox);

export const normal = Template.bind({});
normal.hermioneFn = hoverState;

export const checked = Template.bind({});
checked.args = { checked: true };
checked.hermioneFn = hoverState;

export const disabled = Template.bind({});
disabled.args = { disabled: true };

export const checkedDisabled = Template.bind({});
checkedDisabled.args = { checked: true, disabled: true };
