import * as React from 'react';
import cn from 'classnames/bind';

import styles from 'shared/ui/Checkbox/Checkbox.css';

export interface CheckboxItemOptions {
    label: React.ReactNode;
    id: number | string;
    checked?: boolean;
    disabled?: boolean;
}

export interface CheckboxProps extends CheckboxItemOptions {
    className?: string;

    onChange?(checked: boolean, value: string): void;
}

const cx = cn.bind(styles);

export const Checkbox = React.forwardRef<HTMLLabelElement, CheckboxProps>(function Checkbox(
    { className, id, label, checked, disabled, onChange },
    ref,
) {
    const onChangeHandler = React.useCallback(
        ({ currentTarget }: React.ChangeEvent<HTMLInputElement>) => {
            if (onChange) {
                onChange(currentTarget.checked, currentTarget.value);
            }
        },
        [onChange],
    );

    return (
        <label
            className={cx(styles.checkbox, { disabled }, [className])}
            ref={ref}
        >
            <input
                className={styles.input}
                type="checkbox"
                value={id.toString()}
                checked={Boolean(checked)}
                disabled={disabled}
                onChange={onChangeHandler}
            />

            <span className={styles.label}>{label}</span>
        </label>
    );
});
