import * as React from 'react';
import { Story } from '@storybook/react';

import { CheckboxItemOptions } from 'shared/ui/Checkbox/Checkbox';
import { CheckboxGroup, CheckboxGroupProps } from 'shared/ui/CheckboxGroup/CheckboxGroup';

export default { title: 'shared/CheckboxGroup' };

const Template: Story<CheckboxGroupProps> = (args) => <CheckboxGroup {...args} />;

const ITEMS: CheckboxItemOptions[] = [
    {
        label: 'Signals',
        id: 'signals',
    },
    {
        label: 'Rides',
        id: 'rides',
    },
];

export const normal = Template.bind({});
normal.args = { items: ITEMS };

export const custom = Template.bind({});
custom.args = {
    title: 'Section',
    items: [
        {
            label: 'Signals',
            id: 'signals',
            checked: true,
        },
        {
            label: 'Rides',
            id: 'rides',
            disabled: true,
        },
    ],
};

export const disabled = Template.bind({});
disabled.args = { items: ITEMS, disabled: true };
