import * as React from 'react';
import cn from 'classnames/bind';

import styles from 'shared/ui/ContentContainer/ContentContainer.css';

export interface ContentContainerProps {
    className?: string;

    // @todo: temporary props
    bodyScroll?: boolean;
    withSidebar?: boolean;
}

const cx = cn.bind(styles);

export const ContentContainer: React.FC<ContentContainerProps> = function ContentContainer({
    className,
    bodyScroll,
    withSidebar,
    children,
}) {
    return <div className={cx(styles.contentContainer, { bodyScroll, withSidebar }, [className])}>{children}</div>;
};
