import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import { DetailsContainer, DetailsContainerProps } from 'shared/ui/DetailsContainer/DetailsContainer';

const storybookMeta = createStorybookMeta<DetailsContainerProps>({
    title: 'shared/DetailsContainer',
    component: DetailsContainer,

    args: {
        storybookWidth: '520px',

        items: [
            { label: 'Role', id: 'role', value: 'Admin' },
            {
                label: 'Status',
                id: 'status',
                value: null,
            },
            {
                label: 'Comment',
                id: 'comment',
                value: 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
            },
        ],
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<DetailsContainerProps>(DetailsContainer);

export const normal = Template.bind({});
