import * as React from 'react';
import cn from 'classnames';

import styles from 'shared/ui/DetailsContainer/DetailsContainer.css';

export interface DetailsContainerItemOptions {
    label: React.ReactNode;
    id: string;
    value?: React.ReactNode;
    dataTestId?: string;
}

export interface DetailsContainerProps {
    className?: string;
    items?: DetailsContainerItemOptions[];
}

export const DetailsContainer: React.FC<DetailsContainerProps> = function DetailsContainer({ className, items }) {
    if (!items || !items.length) {
        return null;
    }

    return (
        <dl className={cn(styles.details, className)}>
            {items.map(({ label, id, value, dataTestId }) =>
                value ? (
                    <React.Fragment key={id}>
                        <dt className={styles.label}>{label}</dt>
                        <dd
                            className={styles.value}
                            data-testid={dataTestId}
                        >
                            {value}
                        </dd>
                    </React.Fragment>
                ) : null,
            )}
        </dl>
    );
};
