import * as React from 'react';

import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import { DialogContainer, DialogContainerProps } from 'shared/ui/DialogContainer/DialogContainer';

const storybookMeta = createStorybookMeta<DialogContainerProps>({
    title: 'shared/DialogContainer',
    component: DialogContainer,

    hermioneSelector: 'html',

    args: {
        controls: (
            <>
                <div style={{ height: '40px', backgroundColor: 'pink' }} />
                <div style={{ height: '40px', backgroundColor: 'pink' }} />
            </>
        ),
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<DialogContainerProps>(DialogContainer);

export const normal = Template.bind({});
normal.args = { title: 'Delete signal?' };

export const withDescription = Template.bind({});
withDescription.args = { title: 'Delete signal?', description: 'It can’t be undone' };

export const withClose = Template.bind({});
withClose.args = { title: 'Delete signal?', description: 'It can’t be undone', hasClose: true };
