import * as React from 'react';
import cn from 'classnames';

import { usePortal } from 'shared/hooks/usePortal/usePortal';
import { usePreventScroll } from 'shared/hooks/usePreventScroll/usePreventScroll';
import { BaseDialog, BaseDialogProps } from 'shared/ui/BaseDialog/BaseDialog';

import styles from 'shared/ui/DialogContainer/DialogContainer.css';

export interface DialogContainerProps extends BaseDialogProps {
    closeOnOverlay?: boolean;
}

export const DialogContainer: React.FC<DialogContainerProps> = function DialogContainer({
    className,
    hasOverlay = true,
    closeOnOverlay = true,
    onClose,
    children,
    ...otherProps
}) {
    const Portal = usePortal();

    usePreventScroll({ enabled: true });

    const onOverlayClick = closeOnOverlay ? onClose : undefined;

    return (
        <Portal>
            <div className={styles.dialogContainer}>
                <BaseDialog
                    {...otherProps}
                    className={cn(styles.dialog, className)}
                    hasOverlay={hasOverlay}
                    onClose={onClose}
                    onOverlayClick={onOverlayClick}
                >
                    {children}
                </BaseDialog>
            </div>
        </Portal>
    );
};
