import * as React from 'react';
import cn from 'classnames';

import styles from 'shared/ui/DotText/DotText.css';

export interface DotTextProps {
    className?: string;
    items: React.ReactNode[];
}

export const DotText: React.FC<DotTextProps> = function DotText({ className, items }) {
    return (
        <span className={cn(styles.dotText, className)}>
            {items
                .filter((item) => (typeof item === 'string' ? item.length > 0 : Boolean(item)))
                .map((item, index) => {
                    return (
                        <React.Fragment key={index}>
                            {index ? <i className={styles.dot}>·</i> : null} {item}
                        </React.Fragment>
                    );
                })}
        </span>
    );
};
