import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { hoverState } from 'tests/storybook/helpers/hoverState';

import { ButtonColor } from 'shared/consts/ButtonColor';
import { ButtonSize } from 'shared/consts/ButtonSize';
import { MenuType } from 'shared/consts/MenuType';
import { Dropdown, DropdownProps } from 'shared/ui/Dropdown/Dropdown';

const storybookMeta = createStorybookMeta<DropdownProps>({
    title: 'shared/Dropdown',
    component: Dropdown,

    args: {
        color: ButtonColor.SECONDARY,
        size: ButtonSize.M,
        label: 'Dropdown',
        items: [
            {
                label: 'Driver',
                value: 'driver',
            },
            {
                label: 'Car',
                value: 'car',
            },
            {
                label: 'Licence plate number',
                value: 'licence-number',
            },
            {
                label: 'Mileage',
                value: 'mileage',
            },
        ],
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<DropdownProps>(Dropdown);

async function menuActions(browser: WebdriverIO.Browser, selector: string) {
    const menuEl = '[role="menu"]';

    await browser.$(selector).click();
    await browser.$(menuEl).waitForDisplayed();
    await browser.assertView('opened', [selector, menuEl]);

    await browser.$('li[role="option"]:first-child').click();
    await browser.$(menuEl).waitForDisplayed({ reverse: true });

    return browser.assertView('closed', selector);
}

export const normal = Template.bind({});
normal.hermioneFn = menuActions;

export const primary = Template.bind({});
primary.args = { color: ButtonColor.PRIMARY };

export const error = Template.bind({});
error.args = { hasError: true };
error.hermioneFn = hoverState;

export const check = Template.bind({});
check.args = { menuType: MenuType.CHECK, checkedMenu: ['driver', 'car'] };
check.hermioneFn = async function (browser, selector) {
    const menuEl = '[role="menu"]';

    await browser.$(selector).click();
    await browser.$(menuEl).waitForDisplayed();
    await browser.assertView('opened', [selector, menuEl]);

    await browser.$('li[role="option"]:first-child').click();
    await browser.assertView('checked-option', [selector, menuEl]);

    await browser.$('li[role="option"]:nth-child(1)').click();
    await browser.$('li[role="option"]:nth-child(2)').click();
    await browser.$('li[role="option"]:nth-child(3)').click();
    await browser.$('li[role="option"]:nth-child(4)').click();
    await browser.assertView('checked-options', [selector, menuEl]);

    await browser.$('body').moveTo({ xOffset: 1, yOffset: 1 });
    await browser.$('body').click();
    await browser.$(menuEl).waitForDisplayed({ reverse: true });

    return browser.assertView('closed', selector);
};

export const radio = Template.bind({});
radio.args = { menuType: MenuType.RADIO, checkedMenu: ['car'] };
radio.hermioneFn = menuActions;

export const maxHeight = Template.bind({});
maxHeight.args = {
    items: [
        {
            label: 'Driver',
            value: 'driver',
        },
        {
            label: 'Car',
            value: 'car',
        },
        {
            label: 'Licence plate number',
            value: 'licence-number',
        },
        {
            label: 'Mileage',
            value: 'mileage',
        },
        {
            label: 'Lorem',
            value: 'lorem',
        },
        {
            label: 'Ipsum',
            value: 'ipsum',
        },
        {
            label: 'Simply dummy text',
            value: 'simply-dummy-text',
        },
        {
            label: 'The printing and typesetting industry',
            value: 'printing-typesetting-industry',
        },
    ],
    maxHeight: 190,
};
maxHeight.hermioneFn = menuActions;
