import * as React from 'react';

import { ErrorLoggerSource, logError } from 'shared/helpers/errorLogger/errorLogger';

export interface ErrorBoundaryFallbackProps {
    error: Error;
}

export interface ErrorBoundaryProps {
    fallback: React.ReactNode | React.Component<ErrorBoundaryFallbackProps>;
}

export interface ErrorBoundaryState {
    error: Error | null;
}

export class ErrorBoundary extends React.Component<ErrorBoundaryProps, ErrorBoundaryState> {
    state = { error: null };

    static getDerivedStateFromError(error: Error) {
        return {
            error,
        };
    }

    componentDidCatch(error: Error, errorInfo: React.ErrorInfo) {
        logError(ErrorLoggerSource.ERROR_BOUNDARY, error, errorInfo);
    }

    render() {
        const { error } = this.state;

        if (error) {
            const { fallback, children } = this.props;

            if (!fallback) {
                return children;
            }

            if (typeof fallback === 'function') {
                const FallbackComponent = fallback;

                return <FallbackComponent error={error} />;
            } else {
                return fallback;
            }
        }

        return this.props.children;
    }
}
