import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import { ErrorLabel, ErrorLabelProps } from 'shared/ui/ErrorLabel/ErrorLabel';

const storybookMeta = createStorybookMeta<ErrorLabelProps>({
    title: 'shared/ErrorLabel',
    component: ErrorLabel,

    args: {
        storybookWidth: '560px',
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<ErrorLabelProps>(ErrorLabel);

export const normal = Template.bind({});
normal.args = {
    errors: [{ message: 'required value', code: 'required' }],
};
