import * as React from 'react';
import cn from 'classnames';

import { FormErrorSchema } from 'shared/types/FormErrorSchema';

import styles from 'shared/ui/ErrorLabel/ErrorLabel.css';

export interface ErrorLabelProps {
    className?: string;
    errors: Optional<FormErrorSchema>;
}

export const ErrorLabel: React.FC<ErrorLabelProps> = function ErrorLabel({ className, errors }) {
    if (!errors || !errors.length) {
        return null;
    }

    return (
        <ol className={cn(styles.error, className)}>
            {errors.map(({ message, code }, index) => (
                <li key={code + index}>{message}</li>
            ))}
        </ol>
    );
};
