import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import { ErrorMessage, ErrorMessageProps } from 'shared/ui/ErrorMessage/ErrorMessage';

const storybookMeta = createStorybookMeta<ErrorMessageProps>({
    title: 'shared/ErrorMessage',
    component: ErrorMessage,

    args: {
        storybookWidth: '560px',
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<ErrorMessageProps>(ErrorMessage);

export const normal = Template.bind({});
normal.args = {
    error: [{ message: 'internal server error', code: 'error' }],
};

export const reqid = Template.bind({});
reqid.args = {
    error: [
        {
            message: 'internal server error',
            code: 'error',
        },
        { message: 'reqid: 1234567890-1234567890-DM', code: 'reqid' },
    ],
};
