import * as React from 'react';
import cn from 'classnames';

import { FormErrorSchema } from 'shared/types/FormErrorSchema';

import styles from 'shared/ui/ErrorMessage/ErrorMessage.css';

export interface ErrorMessageProps {
    className?: string;
    error: Optional<FormErrorSchema>;
}

export const ErrorMessage: React.FC<ErrorMessageProps> = function ErrorMessage({ className, error }) {
    if (!error || !error.length) {
        return null;
    }

    return (
        <ul
            className={cn(styles.list, className)}
            role="alert"
        >
            {error.map(({ message, code }, index) => (
                <li
                    className={styles.item}
                    key={code + index}
                >
                    {message}
                </li>
            ))}
        </ul>
    );
};
