import * as React from 'react';
import { Story } from '@storybook/react';

import { FilterGroup, FilterGroupProps } from 'shared/ui/FilterGroup/FilterGroup';

export default { title: 'shared/FilterGroup' };

const Template: Story<FilterGroupProps> = (args) => <FilterGroup {...args} />;

const defaultArgs = {
    children: (
        <>
            <div style={{ width: '200px', height: '50px', backgroundColor: 'pink' }} />
            <div style={{ width: '200px', height: '50px', backgroundColor: 'pink' }} />
        </>
    ),
};

export const normal = Template.bind({});
normal.args = defaultArgs;

export const withTitle = Template.bind({});
withTitle.args = {
    ...defaultArgs,
    title: 'Signals',
};
