import * as React from 'react';
import cn from 'classnames';

import styles from 'shared/ui/FilterGroup/FilterGroup.css';

export interface FilterGroupProps {
    className?: string;
    title?: string;
}

export const FilterGroup: React.FC<FilterGroupProps> = function FilterGroup({ className, title, children }) {
    return (
        <fieldset className={cn(styles.filterGroup, className)}>
            {title && <legend className={styles.title}>{title}</legend>}

            <div className={styles.content}>{children}</div>
        </fieldset>
    );
};
