import * as React from 'react';

import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import { FormContainer, FormContainerProps } from 'shared/ui/FormContainer/FormContainer';

const storybookMeta = createStorybookMeta<FormContainerProps>({
    title: 'shared/FormContainer',
    component: FormContainer,

    args: {
        storybookWidth: '560px',

        children: (
            <>
                <div style={{ height: '40px', backgroundColor: 'pink' }} />
                <div style={{ height: '40px', backgroundColor: 'pink' }} />
            </>
        ),
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<FormContainerProps>(FormContainer);

export const normal = Template.bind({});
