import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Actually finished {date} at {time}': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Actually finished {date} at {time}',
        ru: 'Фактически завершилось {date} в {time}',
        cs: 'Skutečně dokončeno {date} v {time}',
    },
    'Actually started {date} at {time}': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Actually started {date} at {time}',
        ru: 'Фактически началось {date} в {time}',
        cs: 'Skutečně zahájeno {date} v {time}',
    },
    From: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'From',
        ru: 'С',
        cs: 'Od',
    },
    Till: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Till',
        ru: 'По',
        cs: 'Do',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
