import * as React from 'react';

import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import { validateRequired } from 'shared/helpers/validateRequired/validateRequired';
import { useForm } from 'shared/hooks/useForm/useForm';
import { FormDateTimeRangeSchema } from 'shared/types/FormDateTimeRangeSchema';
import { FormDateTimeRange, FormDateTimeRangeProps } from 'shared/ui/FormDateTimeRange/FormDateTimeRange';

const storybookMeta = createStorybookMeta<FormDateTimeRangeProps<{}>>({
    title: 'shared/FormDateTimeRange',
    component: FormDateTimeRange,

    parameters: {
        backgrounds: { default: 'white' },
    },

    args: {
        storybookWidth: '560px',
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<
    FormDateTimeRangeProps<{}> & { since?: Date; until?: Date; withValidation: boolean }
>(({ since, until, withValidation, ...otherProps }) => {
    const { update, watch, errors, validate } = useForm<OptionalRecord<FormDateTimeRangeSchema>>({
        init: { since, since_time: '09:00', until, until_time: '09:00' },
        validation: {
            since: validateRequired(),
            until: validateRequired(),
        },
    });

    React.useEffect(() => {
        if (withValidation) {
            validate();
        }
    }, [withValidation, validate]);

    return (
        <FormDateTimeRange
            {...otherProps}
            title="Dates"
            update={update}
            watch={watch}
            errors={errors}
        />
    );
});

export const normal = Template.bind({});
normal.args = { since: new Date('2022-01-01'), until: new Date('2022-01-31') };

export const empty = Template.bind({});

export const disabled = Template.bind({});
disabled.args = { disableSince: true, disableUntil: true };

export const disabledSince = Template.bind({});
disabledSince.args = { since: new Date('2022-01-01'), until: new Date('2022-01-31'), disableSince: true };

export const disabledUntil = Template.bind({});
disabledUntil.args = { since: new Date('2022-01-01'), until: new Date('2022-01-31'), disableUntil: true };

export const withError = Template.bind({});
withError.args = { withValidation: true };

export const actualDates = Template.bind({});
actualDates.args = {
    since: new Date('2022-01-01'),
    until: new Date('2022-01-31'),
    actualSince: new Date('2022-01-01T10:52:19'),
    actualUntil: new Date('2022-01-31T12:33:19'),
    disableSince: true,
    disableUntil: true,
};
