import * as React from 'react';

import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import { FormErrorContainer, FormErrorContainerProps } from 'shared/ui/FormErrorContainer/FormErrorContainer';

const storybookMeta = createStorybookMeta<FormErrorContainerProps>({
    title: 'shared/FormErrorContainer',
    component: FormErrorContainer,

    args: {
        storybookWidth: '560px',
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<FormErrorContainerProps>(FormErrorContainer);

export const normal = Template.bind({});
normal.args = { children: <div style={{ height: '40px', backgroundColor: 'pink' }} /> };

export const error = Template.bind({});
error.args = {
    error: <div style={{ height: '22px', backgroundColor: 'pink' }} />,
    children: <div style={{ height: '40px', backgroundColor: 'pink' }} />,
};
