import * as React from 'react';
import cn from 'classnames';

import styles from 'shared/ui/FormErrorContainer/FormErrorContainer.css';

export interface FormErrorContainerProps {
    className?: string;

    error?: React.ReactNode;
}

export const FormErrorContainer: React.FC<FormErrorContainerProps> = function FormErrorContainer({
    className,
    error,
    children,
}) {
    return (
        <div className={cn(styles.form, className)}>
            {children}

            {error}
        </div>
    );
};
