import * as React from 'react';

import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import { FormLabel, FormLabelProps } from 'shared/ui/FormLabel/FormLabel';

const storybookMeta = createStorybookMeta<FormLabelProps>({
    title: 'shared/FormLabel',
    component: FormLabel,

    args: {
        storybookWidth: '560px',

        title: 'Lorem Ipsum is simply dummy text',
        children: <div style={{ height: '40px', backgroundColor: 'pink' }} />,
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<FormLabelProps>(FormLabel);

export const normal = Template.bind({});

export const withDescription = Template.bind({});
withDescription.args = { description: 'Lorem Ipsum is simply dummy text of the printing and typesetting industry' };
