import * as React from 'react';

import styles from 'shared/ui/FormLabel/FormLabel.css';

export interface FormLabelProps {
    className?: string;
    formId?: string;
    title: React.ReactNode;
    description?: React.ReactNode;
}

export const FormLabel: React.FC<FormLabelProps> = function FormLabel({
    className,
    formId,
    title,
    description,
    children,
}) {
    return (
        <div className={className}>
            <div className={styles.header}>
                {typeof title === 'string' ? (
                    <label
                        className={styles.title}
                        htmlFor={formId}
                    >
                        {title}
                    </label>
                ) : (
                    title && <div className={styles.title}>{title}</div>
                )}

                {typeof description === 'string' ? (
                    <p className={styles.description}>{description}</p>
                ) : (
                    description && <div className={styles.description}>{description}</div>
                )}
            </div>

            {children}
        </div>
    );
};
