import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    '{used} of {inview} are used': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'TRANSLATED',
                cs: 'APPROVED',
            },
        },
        en: '{used} of {inview} are used',
        ru: '{used} из {inview} используются',
        cs: 'používá se {used} z {inview}',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
