import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import { GPSValueIcon, GPSValueIconProps } from 'shared/ui/GPSValueIcon/GPSValueIcon';

const storybookMeta = createStorybookMeta<GPSValueIconProps>({
    title: 'shared/GPSValueIcon',
    component: GPSValueIcon,
});

export default storybookMeta;

const Template = createStorybookTemplate<GPSValueIconProps>(GPSValueIcon);

export const empty = Template.bind({});
empty.args = {
    GPSUsed: null,
    GPSInview: null,
};

export const bad = Template.bind({});
bad.args = {
    GPSUsed: 9,
    GPSInview: 9,
};

export const normal = Template.bind({});
normal.args = {
    GPSUsed: 12,
    GPSInview: 12,
};

export const good = Template.bind({});
good.args = {
    GPSUsed: 13,
    GPSInview: 13,
};

export const short = Template.bind({});
short.args = {
    GPSUsed: 13,
    GPSInview: 13,
    short: true,
};

export const invalidData = Template.bind({});
invalidData.args = {
    GPSUsed: 15,
    GPSInview: 13,
    short: true,
};

export const onlyInview = Template.bind({});
onlyInview.args = {
    GPSInview: 13,
    short: true,
};

export const onlyUsed = Template.bind({});
onlyUsed.args = {
    GPSUsed: 13,
    short: true,
};
