import * as React from 'react';
import cn from 'classnames/bind';

import { EMPTY_DATA } from 'constants/constants';

import { getSignalLevel } from 'shared/helpers/getSignalLevel/getSignalLevel';

import { i18n } from 'shared/ui/GPSValueIcon/GPSValueIcon.i18n';

import GPSIcon from 'shared/ui/Icons/images/gps-12.inline.svg';

import styles from 'shared/ui/GPSValueIcon/GPSValueIcon.css';

const cx = cn.bind(styles);

export interface GPSValueIconProps {
    GPSInview?: number | null;
    GPSUsed?: number | null;
    short?: boolean;
}

export const GPSValueIcon = ({ GPSInview, GPSUsed, short }: GPSValueIconProps) => {
    const signal = GPSUsed ?? GPSInview;
    // Если используемых спутников нет, считаем те которые в зоне видимости
    const level = getSignalLevel(signal);
    let gpsCount;

    if (!short && GPSUsed && GPSInview && GPSInview >= GPSUsed) {
        gpsCount = i18n('{used} of {inview} are used', {
            used: GPSUsed,
            inview: GPSInview,
        });
    } else {
        gpsCount = signal;
    }

    return (
        <div className={cx(styles.gpsValue)}>
            {gpsCount !== null && gpsCount !== undefined ? (
                <>
                    <GPSIcon className={cx(styles.svg, [level])} />
                    <span>{gpsCount}</span>
                </>
            ) : (
                EMPTY_DATA
            )}
        </div>
    );
};
