import * as React from 'react';

import styles from 'shared/ui/GlobalShimmer/GlobalShimmer.css';

export const ShimmerContext = React.createContext<{
    showShimmer?(value: boolean): void;
}>({});

export const GlobalShimmer: React.FC = function GlobalShimmer({ children }) {
    const [shouldShowShimmer, showShimmer] = React.useState<boolean>();

    return (
        <ShimmerContext.Provider value={{ showShimmer }}>
            {shouldShowShimmer && (
                <div className={styles.globalShimmer}>
                    <div className={styles.animation} />
                </div>
            )}

            {children}
        </ShimmerContext.Provider>
    );
};
