import { buildDummyImageInline } from 'tests/storybook/helpers/buildDummyImageInline';
import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import { ImagesPreviewUpload, ImagesPreviewUploadProps } from 'shared/ui/ImagesPreviewUpload/ImagesPreviewUpload';
import { PictureOptions } from 'shared/ui/Picture/Picture';

const storybookMeta = createStorybookMeta<ImagesPreviewUploadProps>({
    title: 'shared/ImagesPreviewUpload',
    component: ImagesPreviewUpload,

    args: {
        images: [
            {
                src: buildDummyImageInline({ origUrl: 'https://vlootkit.com' }),
                title: 'vlootkit.com',
            },
            {
                src: buildDummyImageInline({ origUrl: 'https://vlootkit.cz' }),
                title: 'vlootkit.cz',
            },
        ],
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<ImagesPreviewUploadProps>(ImagesPreviewUpload);

export const normal = Template.bind({});
normal.args = {
    onChange: () => {},
};

export const maxLength = Template.bind({});
maxLength.args = {
    maxLength: 2,
    onChange: () => {},
};

export const empty = Template.bind({});
empty.args = { images: [{}, { src: 'vlootkit.cz', title: 'vlootkit.cz' }] as PictureOptions[] };

export const loading = Template.bind({});
loading.args = { isLoading: true };

export const upload = Template.bind({});
upload.args = {
    images: [],
    onChange: () => {},
};
