import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { hoverState } from 'tests/storybook/helpers/hoverState';

import { InputPin } from 'shared/consts/InputPin';
import { InputSize } from 'shared/consts/InputSize';
import { Input, InputProps } from 'shared/ui/Input/Input';

const storybookMeta = createStorybookMeta<InputProps>({
    title: 'shared/Input',
    component: Input,

    args: {
        storybookWidth: '320px',

        inputSize: InputSize.M,
        spellCheck: false,
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<InputProps>(Input);

async function hoverInputState(browser, selector) {
    await hoverState(browser, selector);

    await browser.$(selector).click();

    return browser.assertView('focused', selector);
}

export const normal = Template.bind({});
normal.args = { value: 'Input text', hasClear: true };
normal.hermioneFn = hoverInputState;

export const empty = Template.bind({});

export const long = Template.bind({});
long.args = {
    value: 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
    hasClear: true,
};

export const placeholder = Template.bind({});
placeholder.args = { placeholder: 'Placeholder text' };

export const pinLeft = Template.bind({});
pinLeft.args = { pin: InputPin.LEFT, value: 'Input text', hasClear: true };

export const pinRight = Template.bind({});
pinRight.args = { pin: InputPin.RIGHT, value: 'Input text', hasClear: true };

export const pinBoth = Template.bind({});
pinBoth.args = { pin: InputPin.BOTH, value: 'Input text', hasClear: true };

export const invalid = Template.bind({});
invalid.args = { pattern: '[0-9]', value: 'Input text' };
invalid.hermioneFn = hoverInputState;

export const error = Template.bind({});
error.args = { value: 'Input text', hasError: true };
error.hermioneFn = hoverInputState;

export const disabled = Template.bind({});
disabled.args = { placeholder: 'Placeholder text', disabled: true };
disabled.parameters = { backgrounds: { default: 'white' } };

export const disabledText = Template.bind({});
disabledText.args = { placeholder: 'Placeholder text', value: 'Input text', disabled: true };
disabledText.parameters = { backgrounds: { default: 'white' } };

export const withBackground = Template.bind({});
withBackground.args = { withBackground: true };
