import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import { InputSize } from 'shared/consts/InputSize';
import { InputArrow, InputArrowProps } from 'shared/ui/InputArrow/InputArrow';

import PinIcon from 'shared/ui/Icons/images/pin-16.inline.svg';

const storybookMeta = createStorybookMeta<InputArrowProps>({
    title: 'shared/InputArrow',
    component: InputArrow,

    args: {
        storybookWidth: '320px',

        inputSize: InputSize.M,
        placeholder: 'Placeholder text',
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<InputArrowProps>(InputArrow);

export const normal = Template.bind({});

export const normalWithText = Template.bind({});
normalWithText.args = { value: 'Input text' };

export const opened = Template.bind({});
opened.args = { opened: true };

export const openedWithText = Template.bind({});
openedWithText.args = { value: 'Input text', opened: true };

export const withoutArrow = Template.bind({});
withoutArrow.args = { hasArrow: false };

export const withoutArrowText = Template.bind({});
withoutArrowText.args = { value: 'Input text', hasArrow: false };

export const icon = Template.bind({});
icon.args = { icon: PinIcon };

export const iconWithText = Template.bind({});
iconWithText.args = { value: 'Input text', icon: PinIcon };

export const disabled = Template.bind({});
disabled.args = { value: 'Input text', icon: PinIcon, disabled: true };
