import * as React from 'react';
import cn from 'classnames/bind';

import { Input, InputProps } from 'shared/ui/Input/Input';
import { InputIcon } from 'shared/ui/InputIcon/InputIcon';

import ArrowIcon from 'shared/ui/Icons/images/arrow-short-bottom-16.inline.svg';

import styles from 'shared/ui/InputArrow/InputArrow.css';

export interface InputArrowProps extends InputProps {
    className?: string;
    icon?: SvgIcon;
    opened?: boolean;
    hasArrow?: boolean;
}

const cx = cn.bind(styles);

export const InputArrow: React.FC<InputArrowProps> = function InputArrow({
    className,
    value,
    disabled,
    icon,
    opened,
    hasArrow = true,
    ...otherProps
}) {
    const isClearVisible = Boolean(!disabled && value?.toString().length);

    return (
        <Input
            {...otherProps}
            className={cx({ opened, hasArrow, disabled }, [className])}
            value={value}
            disabled={disabled}
            hasClear
        >
            {icon ? (
                <InputIcon
                    className={styles.inputIcon}
                    icon={icon}
                    visible={!isClearVisible}
                />
            ) : (
                hasArrow && (
                    <span className={cx(styles.arrowIcon, { visible: !isClearVisible })}>
                        <ArrowIcon />
                    </span>
                )
            )}
        </Input>
    );
};
