import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import { InputSize } from 'shared/consts/InputSize';
import { InputDate, InputDateProps } from 'shared/ui/InputDate/InputDate';

const storybookMeta = createStorybookMeta<InputDateProps>({
    title: 'shared/InputDate',
    component: InputDate,

    args: {
        storybookWidth: '320px',

        inputSize: InputSize.M,
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<InputDateProps>(InputDate);

export const normal = Template.bind({});

export const withText = Template.bind({});
withText.args = { value: 'Input text' };
