import * as React from 'react';
import cn from 'classnames';

import { InputArrow, InputArrowProps } from 'shared/ui/InputArrow/InputArrow';

import EventIcon from 'shared/ui/Icons/images/event-16.inline.svg';

import styles from 'shared/ui/InputDate/InputDate.css';

export interface InputDateProps extends InputArrowProps {
    className?: string;
}

export const CLOSE_ANIMATION_TIME = 150;
export const DEFAULT_DATE_FORMAT: Intl.DateTimeFormatOptions = {
    day: '2-digit',
    month: '2-digit',
    year: 'numeric',
};

export const InputDate: React.FC<InputDateProps> = function InputDate({ className, focused, ...otherProps }) {
    return (
        <InputArrow
            {...otherProps}
            className={cn(styles.inputDate, className)}
            focused={focused}
            shouldFocusOnClear={false}
            icon={EventIcon}
            hasArrow={false}
        />
    );
};
