import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import { InputSize } from 'shared/consts/InputSize';
import { InputDateRange, InputDateRangeProps } from 'shared/ui/InputDateRange/InputDateRange';

const storybookMeta = createStorybookMeta<InputDateRangeProps>({
    title: 'shared/InputDateRange',
    component: InputDateRange,

    parameters: { date: new Date('2022-04-04') },

    args: {
        storybookWidth: '320px',

        inputSize: InputSize.M,
    },
});

export default storybookMeta;

async function calendarState(browser: WebdriverIO.Browser, selector: string) {
    const calendar = '[data-portal-id] > div';

    await browser.$('input[name="startDate"]').click();
    await browser.$(calendar).waitForDisplayed();
    await browser.assertView('opened', [selector, calendar]);

    await browser.$('button[type=button]:nth-child(16)').click();
    await browser.assertView('from', [selector, calendar]);

    await browser.$('button[type=button]:nth-child(20)').click();
    await browser.$(calendar).waitForDisplayed({ reverse: true });

    return browser.assertView('closed', selector);
}

const Template = createStorybookTemplate<InputDateRangeProps>(InputDateRange);

export const normal = Template.bind({});
normal.args = { dates: [new Date('2022-01-15'), new Date('2022-02-18')] };
normal.hermioneFn = calendarState;

export const placeholder = Template.bind({});
placeholder.args = { placeholders: ['Placeholder text 1', 'Placeholder text 2'] };
placeholder.hermioneFn = calendarState;

export const minMax = Template.bind({});
minMax.args = {
    dates: [new Date('2022-01-15'), new Date('2022-02-18')],
    minBookingDate: new Date('2022-01-10'),
    maxBookingDate: new Date('2022-02-20'),
};
minMax.hermioneFn = calendarState;

export const monthChange = Template.bind({});
monthChange.hermionePlainFn = async function (browser, selector) {
    const calendar = '[data-portal-id] > div';

    await browser.$('input[name="startDate"]').click();
    await browser.$(calendar).waitForDisplayed();
    await browser.assertView('plain', [selector, calendar]);

    await browser.$('button[class*="__arrow"]:first-child').click();
    await browser.assertView('prev-click', [selector, calendar]);

    await browser.$('button[type=button]:nth-child(16)').click();
    await browser.assertView('from', [selector, calendar]);

    await browser.$('button[class*="__arrow"]:last-child').click();
    await browser.assertView('next-click', [selector, calendar]);

    await browser.$('button[type=button]:nth-child(20)').click();
    await browser.$(calendar).waitForDisplayed({ reverse: true });

    return browser.assertView('closed', selector);
};

export const yearChange = Template.bind({});
yearChange.args = { nextYearStep: 10 };
yearChange.hermionePlainFn = async function (browser, selector) {
    const calendar = '[data-portal-id] > div';

    await browser.$('input[name="startDate"]').click();
    await browser.$(calendar).waitForDisplayed();
    await browser.assertView('plain', [selector, calendar]);

    await browser.$('[class*="__title"] > [class*="__link"]').click();
    await browser.assertView('year-list', [selector, calendar]);

    await browser.$('li[role="option"]:nth-child(3)').click();
    await browser.assertView('year-changed', [selector, calendar]);

    await browser.$('button[type=button]:nth-child(16)').click();
    await browser.assertView('from', [selector, calendar]);

    await browser.$('button[type=button]:nth-child(20)').click();
    await browser.$(calendar).waitForDisplayed({ reverse: true });

    return browser.assertView('closed', selector);
};
