import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import { InputSize } from 'shared/consts/InputSize';
import { InputDescription, InputDescriptionProps } from 'shared/ui/InputDescription/InputDescription';

const storybookMeta = createStorybookMeta<InputDescriptionProps>({
    title: 'shared/InputDescription',
    component: InputDescription,

    args: {
        storybookWidth: '320px',

        inputSize: InputSize.M,
        description: 'km/day',
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<InputDescriptionProps>(InputDescription);

async function plainState(browser: WebdriverIO.Browser, selector: string) {
    await browser.$('input ~ *:last-child').waitForDisplayed();

    return browser.assertView('plain', selector);
}

export const normal = Template.bind({});
normal.args = { value: 'Input text', hasClear: true };
normal.hermionePlainFn = plainState;

export const empty = Template.bind({});
empty.hermionePlainFn = plainState;

export const long = Template.bind({});
long.args = { value: 'Lorem Ipsum is simply dummy text of the printing and typesetting industry' };
long.hermionePlainFn = plainState;

export const longClear = Template.bind({});
longClear.args = {
    value: 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
    hasClear: true,
};
longClear.hermionePlainFn = plainState;
