import * as React from 'react';

import { useItemRef } from 'shared/hooks/useItemRef/useItemRef';
import { Input, InputProps } from 'shared/ui/Input/Input';

import styles from 'shared/ui/InputDescription/InputDescription.css';

export interface InputDescriptionProps extends InputProps {
    className?: string;
    description?: string;
}

export const InputDescription: React.FC<InputDescriptionProps> = function InputDescription({
    className,
    description,
    setRef,
    ...otherProps
}) {
    const { ref, itemRef } = useItemRef<HTMLElement>(setRef);

    const onDescriptionClickHandler = React.useCallback(() => {
        if (ref.current) {
            ref.current.focus();
        }
    }, [ref.current]);

    return (
        <Input
            {...otherProps}
            setRef={itemRef}
        >
            {description && (
                <span
                    className={styles.description}
                    onClick={onDescriptionClickHandler}
                >
                    {description}
                </span>
            )}
        </Input>
    );
};
