import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import { InputSize } from 'shared/consts/InputSize';
import { InputEmail, InputEmailProps } from 'shared/ui/InputEmail/InputEmail';

const storybookMeta = createStorybookMeta<InputEmailProps>({
    title: 'shared/InputEmail',
    component: InputEmail,

    args: {
        storybookWidth: '320px',

        inputSize: InputSize.M,
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<InputEmailProps>(InputEmail);

export const empty = Template.bind({});

export const normal = Template.bind({});
normal.args = { value: 'test@gmail.com' };

export const invalid = Template.bind({});
invalid.args = { value: 'test' };
