import * as React from 'react';

import { EMAIL_MATCH } from 'shared/consts/email';
import { Input, InputProps } from 'shared/ui/Input/Input';

export type InputEmailProps = InputProps;

export const InputEmail: React.FC<InputEmailProps> = function InputEmail(props) {
    return (
        <Input
            {...props}
            inputMode="email"
            pattern={EMAIL_MATCH.toString().slice(1, -1)}
        />
    );
};
