import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { hoverState } from 'tests/storybook/helpers/hoverState';

import { InputIcon, InputIconProps } from 'shared/ui/InputIcon/InputIcon';

import CloseIcon from 'shared/ui/Icons/images/close-16.inline.svg';

const storybookMeta = createStorybookMeta<InputIconProps>({
    title: 'shared/InputIcon',
    component: InputIcon,

    args: {
        storybookStyles: { lineHeight: 0 },

        icon: CloseIcon,
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<InputIconProps>(InputIcon);

export const visible = Template.bind({});
visible.args = {
    visible: true,
    onClick: () => {},
};
visible.hermioneFn = hoverState;

export const disabled = Template.bind({});
disabled.args = { visible: true };
disabled.hermioneFn = hoverState;

export const hidden = Template.bind({});
