import * as React from 'react';
import cn from 'classnames/bind';

import styles from 'shared/ui/InputIcon/InputIcon.css';

export interface InputIconProps {
    className?: string;
    icon: SvgIcon;
    visible: boolean;

    onClick?(event: React.MouseEvent<HTMLSpanElement>): void;
}

const cx = cn.bind(styles);

export const InputIcon: React.FC<InputIconProps> = function InputIcon({ className, icon: Icon, visible, onClick }) {
    return (
        <span
            className={cx(styles.inputIcon, { visible, disabled: !Boolean(onClick) }, [className])}
            onClick={onClick}
            aria-hidden
            role={onClick ? 'button' : 'none'}
        >
            <Icon />
        </span>
    );
};
